VERSION 5.00
Begin VB.Form frmDocument 
   Caption         =   "File Renamer"
   ClientHeight    =   3240
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7095
   Icon            =   "frmDocument.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3240
   ScaleWidth      =   7095
   Begin VB.Frame Frame2 
      Caption         =   "Timer Settings:"
      Height          =   2295
      Left            =   3600
      TabIndex        =   13
      Top             =   120
      Width           =   3375
      Begin VB.CommandButton cmdActivate 
         Caption         =   "Activate"
         Height          =   375
         Left            =   840
         TabIndex        =   8
         ToolTipText     =   "Start/Stop the timer"
         Top             =   1800
         Width           =   1575
      End
      Begin VB.ComboBox cboAmPm 
         Height          =   315
         Left            =   2280
         TabIndex        =   6
         Text            =   "AM"
         ToolTipText     =   "AM/PM"
         Top             =   600
         Width           =   635
      End
      Begin VB.ComboBox Combo1 
         Appearance      =   0  'Flat
         Height          =   315
         Left            =   240
         Style           =   2  'Dropdown List
         TabIndex        =   7
         ToolTipText     =   "How often should the file be renamed?"
         Top             =   1320
         Width           =   1455
      End
      Begin VB.ComboBox cboHour 
         Height          =   315
         ItemData        =   "frmDocument.frx":0442
         Left            =   240
         List            =   "frmDocument.frx":0444
         TabIndex        =   4
         Text            =   "Hour"
         ToolTipText     =   "Hour"
         Top             =   600
         Width           =   855
      End
      Begin VB.ComboBox cboMin 
         Height          =   315
         Left            =   1270
         TabIndex        =   5
         Text            =   "Min"
         ToolTipText     =   "Minute"
         Top             =   600
         Width           =   855
      End
      Begin VB.Label Label5 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         Caption         =   ":"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1150
         TabIndex        =   16
         Top             =   600
         Width           =   135
      End
      Begin VB.Label Label6 
         Appearance      =   0  'Flat
         Caption         =   "Rename at time:"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   360
         Width           =   1575
      End
      Begin VB.Label Label4 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         Caption         =   "Frequency:"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   1080
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "File Details:"
      Height          =   2295
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3255
      Begin VB.CommandButton cmdInput 
         Height          =   285
         Left            =   2520
         Picture         =   "frmDocument.frx":0446
         Style           =   1  'Graphical
         TabIndex        =   12
         Top             =   600
         Width           =   495
      End
      Begin VB.TextBox Text1 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   240
         TabIndex        =   1
         ToolTipText     =   "File to be renamed"
         Top             =   600
         Width           =   2175
      End
      Begin VB.TextBox Text2 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   240
         MaxLength       =   3
         TabIndex        =   3
         ToolTipText     =   "New file extention (without the ""."")"
         Top             =   1800
         Width           =   615
      End
      Begin VB.TextBox txtPreAmble 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   240
         MaxLength       =   40
         TabIndex        =   2
         ToolTipText     =   "Text to appear in front of new file name"
         Top             =   1200
         Width           =   2175
      End
      Begin VB.Label Label1 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         Caption         =   "Input file:"
         ForeColor       =   &H80000008&
         Height          =   195
         Left            =   240
         TabIndex        =   11
         Top             =   360
         Width           =   645
      End
      Begin VB.Label Label3 
         Appearance      =   0  'Flat
         Caption         =   "New filename extension:"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   1590
         Width           =   1935
      End
      Begin VB.Label Label7 
         Caption         =   "New filename preamble:"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   1005
         Width           =   2295
      End
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   59999
      Left            =   6720
      Top             =   360
   End
   Begin VB.Label Label2 
      Caption         =   $"frmDocument.frx":0A70
      Height          =   615
      Left            =   240
      TabIndex        =   17
      Top             =   2520
      Width           =   6615
   End
End
Attribute VB_Name = "frmDocument"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'All controls will update the isDirty variable on change
Private Sub cboAmPm_Click()
    IsDirty = True
End Sub

Private Sub cboHour_Click()
    IsDirty = True
End Sub

Private Sub cboMin_Click()
    IsDirty = True
End Sub

Private Sub Text1_Change()
    IsDirty = True
End Sub

Private Sub Text2_Change()
    IsDirty = True
End Sub

Private Sub Combo1_Click()
    IsDirty = True
End Sub

Private Sub txtPreAmble_Change()
    IsDirty = True
End Sub

'enables/disables the timer
Public Sub cmdActivate_Click()
On Error GoTo Error_Handler 'trap errors

    IsDirty = True      'mark as dirty
    
    'Check that most important variables have been entered
    If cboHour.Text = "Hour" Then
        MsgBox "You forgot to set the time!"
    ElseIf cboMin.Text = "Min" Then
        MsgBox "You forgot to set the time!"
    ElseIf Text1.Text = "" Then
        MsgBox "You forgot to select a file to rename!"
    Else
        If cmdActivate.Caption = "Activate" Then
            Timer1.Enabled = True               'enable timer
            cmdActivate.Caption = "Deactivate"  'change button caption
            'Update log
            updateLog ICO_INFO, " " & Now & " : " & Me.Caption & " Activated "
        Else
            Timer1.Enabled = False              'disable timer
            cmdActivate.Caption = "Activate"    'change button caption
            'Update log
            updateLog ICO_INFO, " " & Now & " : " & Me.Caption & " Deactivated "
        End If
    End If
Exit_Normal:
    Exit Sub

Error_Handler:
    'MsgBox cmdActivate.Caption & " Error: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : Error: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
End Sub

'browse button
Private Sub cmdInput_Click()
On Error GoTo Error_Handler 'trap errors

    'Pick file to open
    cFile.VBGetOpenFileName SFile, , , , , True, "All Files (*.*)|*.*", , , "Select File to Rename", , Me.hwnd
    If SFile = vbNullString Then Exit Sub

    'insert filename into input file text box
    Text1.Text = SFile

Exit_Normal:
    Exit Sub

Error_Handler:
    'MsgBox "cmdInput_Click: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : cmdInput_Click Error: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal
End Sub

Private Sub Form_Load()
    
    'set default height and width, mark as clean
    Me.Width = 7215
    Me.Height = 3645
    
    'Initialize Frequency drop down box
    Combo1.AddItem "Daily"
    Combo1.AddItem "Sunday"
    Combo1.AddItem "Monday"
    Combo1.AddItem "Tuesday"
    Combo1.AddItem "Wednesday"
    Combo1.AddItem "Thursday"
    Combo1.AddItem "Friday"
    Combo1.AddItem "Saturday"
    Combo1.ListIndex = 0
    
    'Initialize Hour drop down box
    cboHour.AddItem "1"
    cboHour.AddItem "2"
    cboHour.AddItem "3"
    cboHour.AddItem "4"
    cboHour.AddItem "5"
    cboHour.AddItem "6"
    cboHour.AddItem "7"
    cboHour.AddItem "8"
    cboHour.AddItem "9"
    cboHour.AddItem "10"
    cboHour.AddItem "11"
    cboHour.AddItem "12"
    
    'Initialize Minute drop down box
    cboMin.AddItem "00"
    cboMin.AddItem "05"
    cboMin.AddItem "10"
    cboMin.AddItem "15"
    cboMin.AddItem "20"
    cboMin.AddItem "25"
    cboMin.AddItem "30"
    cboMin.AddItem "35"
    cboMin.AddItem "40"
    cboMin.AddItem "45"
    cboMin.AddItem "50"
    cboMin.AddItem "55"
    
    'Initialize AM/PM drop down box
    cboAmPm.AddItem "AM"
    cboAmPm.AddItem "PM"
    cboAmPm.ListIndex = 0
       
    IsDirty = False
    
End Sub

'unload event of form
Private Sub Form_Unload(Cancel As Integer)
'    On Error GoTo Error_Handler     'trap errors
    If IsDirty = True Then             'if this form marked as dirty
        'prompt to save changes
        Select Case MsgBox("Do you want to save the changes you made to " & Me.Caption & "?", vbYesNo + vbQuestion, "Renamer")
            Case vbYes          'If user wants to save changes
                'If file is saved the caption will be "Renamer - Filename.rnm"
                ' Otherwise will be just "Renamer" so check for "-" character
                ' If not found then display Save As... Dialog
                
                If InStr(1, Forms(0).Caption, "-") = 0 Or SFile = "" Then
                    If Not cFile.VBGetSaveFileName(SFile, , True, "Settings (*.rnm)|*.rnm", , , "Save your settings", "Rnm", Me.hwnd) Then Exit Sub
                    If SFile = vbNullString Then Exit Sub '(Save cancelled)
                Else
                    'SFile = Right(Me.Caption, Len(Me.Caption) - 10)
                    writeprofilesettings (SFile)
                End If
                IsDirty = False
            Case Else 'do not save changes
                'do nothing
                IsDirty = False
        End Select
    Else    'Form not dirty so just close

    End If

Exit_Normal:
    Forms(0).Caption = "Renamer"
    Exit Sub

Error_Handler:
    'MsgBox "Error Unloading Document: " & Err.Number & " : " & Err.Description, vbCritical, "Renamer"
    'Update log
    updateLog ICO_ERR, " " & Now & " : Error Unloading Document: " & Err.Number & " : " & Err.Description
    Resume Exit_Normal

End Sub

Private Sub Timer1_Timer()

    On Error GoTo Error_Handler     'trap errors
    
    'initialize variables
    MyHour = Format$(Val(cboHour.Text), "00")
    mymins = Format$(Val(cboMin.Text), "00")
    frequency = Combo1.Text
    myext$ = Text2.Text
      
    'If no extension entered then use .txt as default
    If myext$ = "" Then myext$ = "txt"
    
    'convert to 24 hour clock
    If cboAmPm.Text = "AM" Then
        If Val(MyHour) = Val("12") Then MyHour = "00"
    Else
        If Val(MyHour) <> Val("12") Then MyHour = MyHour + 12
    End If

'    Debug.Print Format$(Now, "dddd"), frequency
'    Debug.Print Format$(Now, "hh"), MyHour
'    Debug.Print Format$(Now, "nn"), mymins
    
    ' If to run on specific day, is today that day? If not, quit.
    If frequency <> "Daily" Then
        If Format$(Now, "dddd") <> frequency Then GoTo Exit_Normal
    End If
    
    'check current time against shceduled rename time, if they do not match then quit
    If Format$(Now, "hh") <> MyHour Then GoTo Exit_Normal
    If Format$(Now, "nn") <> mymins Then GoTo Exit_Normal
    
    'On Error Resume Next
    If Date$ <> LastDate$ Then
        'Beep
        LastDate$ = Date$
        OldFileName$ = Text1.Text       'File to rename
        
        'Parse filepath
        FilePathLen% = Len(OldFileName$)
        For x% = FilePathLen% To 1 Step -1
            If Mid$(OldFileName$, x%, 1) = "\" Then Exit For
        Next
     
        FilePath$ = Mid$(OldFileName$, 1, x%)
        
        'Parse Filename
        FileTitle$ = Mid$(OldFileName$, x% + 1, Len(OldFileName$) - x%)
            
        'Construct new filename based on preamble text, date and new extension
        NewFilename$ = FilePath$ & txtPreAmble.Text & Format$(Now, "YYMMDD") & "." & myext$
     
        'Debug.Print FilePath$, OldFileName$, NewFilename$
        
        'Rename file
        Name OldFileName$ As NewFilename$
        
        'Update log
        updateLog ICO_INFO, " " & Now & " " & OldFileName$ & " has been renamed " & NewFilename$
        
    End If

Exit_Normal:
    Exit Sub

' On error we will update status bar text with message.
Error_Handler:
    If Err.Number = 53 Then ' file does not exist
        'MsgBox "Error: The File you are trying to rename does not exist", vbCritical, "Renamer"
        Beep
        'Update log
        updateLog ICO_ERR, " " & Now & " : Error: " & FileTitle$ & " does not exist."
    Else
        Beep
        'Update log
        updateLog ICO_ERR, " " & Now & " : Error: " & Err.Number & " : " & Err.Description
    End If
    Resume Exit_Normal
    
End Sub

